/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInput;
import java.io.Serializable;

public class HexInput
extends StringInput
implements JDMInput {
    public HexInput() {
    }

    public HexInput(String string, int n) {
        super(string, n);
    }

    public HexInput(String string, int n, int n2) {
        super(string, n, n2);
    }

    public boolean isValidValue(String string) {
        if (string.length() / 2 > this.maxlength) {
            return false;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean isValidValue() {
        if (this.hasErrorValue) {
            return false;
        }
        return this.isValidValue(this.getText());
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    public String hexValue() {
        return this.getText();
    }

    public Object getValue() {
        return new OctetString(this.getText());
    }

    public void setValue(Object object) {
        Serializable serializable;
        if (object instanceof OctetString) {
            serializable = (OctetString)object;
            super.setValue(serializable.toString());
        }
        if (object instanceof SpecialValue) {
            serializable = (SpecialValue)object;
            super.setValue(serializable);
        }
    }

    public void setValue(String string) {
        super.setValue(string);
    }

    public void setMaxLength(int n) {
        this.maxlength = n;
    }
}

